/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.recipebook.GhostRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AdvancementsRecipeRenderer
implements PlaceRecipe<Ingredient> {
    private static final Minecraft MCINSTANCE = Minecraft.m_91087_();
    private static final ResourceLocation GUI_TEXTURE_CRAFTING_TABLE = new ResourceLocation("textures/gui/container/crafting_table.png");
    private static final ResourceLocation GUI_TEXTURE_FURNACE = new ResourceLocation("textures/gui/container/furnace.png");
    private static final ResourceLocation GUI_TEXTURE_BLAST_FURNACE = new ResourceLocation("textures/gui/container/blast_furnace.png");
    private static final ResourceLocation GUI_TEXTURE_SMOKER = new ResourceLocation("textures/gui/container/smoker.png");
    private static final ResourceLocation GUI_TEXTURE_SMITHING = new ResourceLocation("textures/gui/container/smithing.png");
    private static final ResourceLocation GUI_TEXTURE_ANVIL = new ResourceLocation("textures/gui/container/anvil.png");
    public static ItemStack target = null;
    public static GhostRecipe gr = new GhostRecipe();
    public static ResourceLocation currentRecipe = null;
    static final RecipeType<DummyAnvilRecipe> dummy_anvilType = new RecipeType<DummyAnvilRecipe>(){

        public String toString() {
            return "sb_forgeing";
        }
    };
    static RecipeView currentView = null;
    static Map<RecipeType<?>, RecipeView> typeRecipeViewMap = AdvancementsRecipeRenderer.createRecipeViewMap();

    public static AdvancementsRecipeRenderer getInstance() {
        return SingletonHolder.instance;
    }

    private AdvancementsRecipeRenderer() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    static Recipe<?> overrideDummyRecipe(Recipe<?> original) {
        if (!(original instanceof SmithingTransformRecipe)) {
            return original;
        }
        if (original.m_6423_().m_135815_().startsWith("anvilcrafting")) {
            return new DummyAnvilRecipe((SmithingTransformRecipe)original);
        }
        return new DummySmithingRecipe((SmithingTransformRecipe)original);
    }

    static Map<RecipeType<?>, RecipeView> createRecipeViewMap() {
        HashMap map = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        list.add(new Vec3i(124, 35, 0));
        int SlotMargin = 18;
        int LeftMargin = 30;
        int TopMargin = 17;
        int RecipeGridX = 3;
        int RecipeGridY = 3;
        for (int i = 0; i < RecipeGridX; ++i) {
            for (int j = 0; j < RecipeGridY; ++j) {
                list.add(new Vec3i(LeftMargin + j * SlotMargin, TopMargin + i * SlotMargin, 0));
            }
        }
        RecipeType key = RecipeType.f_44107_;
        map.put(key, new RecipeView(key, GUI_TEXTURE_CRAFTING_TABLE, list));
        list = Lists.newArrayList();
        list.add(new Vec3i(116, 35, 0));
        list.add(new Vec3i(56, 17, 0));
        list.add(new Vec3i(56, 53, 0));
        RecipeType<DummyAnvilRecipe> key2 = RecipeType.f_44108_;
        map.put(key2, new RecipeView(key2, GUI_TEXTURE_FURNACE, list));
        key2 = RecipeType.f_44109_;
        map.put(key2, new RecipeView(key2, GUI_TEXTURE_BLAST_FURNACE, list));
        key2 = RecipeType.f_44110_;
        map.put(key2, new RecipeView(key2, GUI_TEXTURE_SMOKER, list));
        list = Lists.newArrayList();
        list.add(new Vec3i(134, 47, 0));
        list.add(new Vec3i(27, 47, 0));
        list.add(new Vec3i(76, 47, 0));
        key2 = RecipeType.f_44113_;
        map.put(key2, new RecipeView(key2, GUI_TEXTURE_SMITHING, list, false));
        key2 = dummy_anvilType;
        map.put(key2, new RecipeView(key2, GUI_TEXTURE_ANVIL, list, false));
        return map;
    }

    public void m_5817_(Iterator<Ingredient> ingredients, int slotIn, int maxAmount, int y, int x) {
        Ingredient ingredient = ingredients.next();
        if (!ingredient.m_43947_() && slotIn < AdvancementsRecipeRenderer.currentView.slots.size()) {
            Vec3i slot = AdvancementsRecipeRenderer.currentView.slots.get(slotIn);
            gr.m_100143_(ingredient, slot.m_123341_(), slot.m_123342_());
        }
    }

    static void clearGhostRecipe() {
        target = null;
        gr.m_100140_();
        currentRecipe = null;
        currentView = null;
    }

    static void setGhostRecipe(ItemStack icon) {
        if (icon != null && icon.m_41782_() && icon.m_41783_().m_128441_("Crafting")) {
            AdvancementsRecipeRenderer.getInstance().setGhostRecipe(new ResourceLocation(icon.m_41783_().m_128461_("Crafting")));
        }
        target = icon;
    }

    void setGhostRecipe(ResourceLocation loc) {
        if (!Objects.equals(loc, currentRecipe)) {
            currentRecipe = loc;
            Optional recipe = AdvancementsRecipeRenderer.MCINSTANCE.f_91073_.m_7465_().m_44043_(loc);
            if (recipe.isPresent()) {
                gr.m_100140_();
                Recipe<?> iRecipe = (Recipe<?>)recipe.get();
                iRecipe = AdvancementsRecipeRenderer.overrideDummyRecipe(iRecipe);
                gr.m_100147_(iRecipe);
                currentView = typeRecipeViewMap.get(iRecipe.m_6671_());
                if (currentView != null && 0 < AdvancementsRecipeRenderer.currentView.slots.size()) {
                    boolean outputslotIndex = false;
                    Vec3i outputSlot = AdvancementsRecipeRenderer.currentView.slots.get(0);
                    gr.m_100143_(Ingredient.m_43927_((ItemStack[])new ItemStack[]{iRecipe.m_8043_(null)}), outputSlot.m_123341_(), outputSlot.m_123342_());
                    this.m_135408_(3, 3, 0, iRecipe, iRecipe.m_7527_().iterator(), 1);
                }
            } else {
                gr.m_100140_();
            }
        }
    }

    void drawBackGround(GuiGraphics gg, int xCorner, int yCorner, int zOffset, int xSize, int ySize, int yClip) {
        int bPadding = 5;
        gg.m_280398_(AdvancementsRecipeRenderer.currentView.background, xCorner, yCorner, zOffset, 0.0f, 0.0f, xSize, yClip - bPadding, 256, 256);
        gg.m_280398_(AdvancementsRecipeRenderer.currentView.background, xCorner, yCorner + yClip - bPadding, zOffset, 0.0f, (float)(ySize - bPadding), xSize, bPadding, 256, 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawGhostRecipe(GuiGraphics gg, int xCorner, int yCorner, int zOffset, float partialTicks) {
        try {
            gg.m_280168_().m_85836_();
            int padding = 5;
            gg.m_280203_(gr.m_100159_().m_8042_(), xCorner + padding, yCorner + padding);
            boolean wideOutputSlot = AdvancementsRecipeRenderer.currentView.isWideOutputSlot;
            gr.m_280269_(gg, MCINSTANCE, xCorner, yCorner, wideOutputSlot, partialTicks);
        }
        finally {
            gg.m_280168_().m_85849_();
        }
    }

    void drawTooltip(GuiGraphics gg, int xCorner, int yCorner, int zOffset, int mouseX, int mouseY, Screen gui) {
        ItemStack itemStack = null;
        int slotSize = 16;
        for (int i = 0; i < gr.m_100158_(); ++i) {
            GhostRecipe.GhostIngredient ghostIngredient = gr.m_100141_(i);
            int j = ghostIngredient.m_100169_() + xCorner;
            int k = ghostIngredient.m_100170_() + yCorner;
            if (mouseX < j || mouseY < k || mouseX >= j + slotSize || mouseY >= k + slotSize) continue;
            itemStack = ghostIngredient.m_100171_();
        }
        if (itemStack != null && itemStack != null && AdvancementsRecipeRenderer.MCINSTANCE.f_91080_ != null) {
            gg.m_280153_(AdvancementsRecipeRenderer.MCINSTANCE.f_91062_, itemStack, mouseX, mouseY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onDrawScreenPost(ScreenEvent.Render.Post event) {
        if (!(event.getScreen() instanceof AdvancementsScreen)) {
            return;
        }
        if (currentRecipe == null) {
            return;
        }
        if (currentView == null) {
            return;
        }
        AdvancementsScreen gui = (AdvancementsScreen)event.getScreen();
        try {
            event.getGuiGraphics().m_280168_().m_85836_();
            PoseStack matrixStack = event.getGuiGraphics().m_280168_();
            int zOffset = 425;
            int zStep = 75;
            matrixStack.m_252880_(0.0f, 0.0f, (float)zOffset);
            int xSize = 176;
            int ySize = 166;
            int yClip = 85;
            int xCorner = (gui.f_96543_ - xSize) / 2;
            int yCorner = (gui.f_96544_ - yClip) / 2;
            this.drawBackGround(event.getGuiGraphics(), xCorner, yCorner, zOffset, xSize, ySize, yClip);
            this.drawGhostRecipe(event.getGuiGraphics(), xCorner, yCorner, zOffset, event.getPartialTick());
            matrixStack.m_252880_(0.0f, 0.0f, (float)zStep);
            this.drawTooltip(event.getGuiGraphics(), xCorner, yCorner, zOffset, event.getMouseX(), event.getMouseY(), (Screen)gui);
        }
        finally {
            event.getGuiGraphics().m_280168_().m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onInitGuiPost(ScreenEvent.Init.Post event) {
        if (!(event.getScreen() instanceof AdvancementsScreen)) {
            return;
        }
        AdvancementsScreen gui = (AdvancementsScreen)event.getScreen();
        gui.m_6702_().add(new AdvancementsExGuiEventListener(gui));
    }

    private static final class SingletonHolder {
        private static final AdvancementsRecipeRenderer instance = new AdvancementsRecipeRenderer();

        private SingletonHolder() {
        }
    }

    static class DummyAnvilRecipe
    implements Recipe<Container> {
        protected SmithingTransformRecipe original;
        private final ItemStack result;
        private final ResourceLocation recipeId;
        NonNullList<Ingredient> nonnulllist = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);

        public DummyAnvilRecipe(SmithingTransformRecipe recipe) {
            this.original = recipe;
            FriendlyByteBuf pb = new FriendlyByteBuf(Unpooled.buffer());
            SmithingTransformRecipe.Serializer ss = new SmithingTransformRecipe.Serializer();
            ss.m_6178_(pb, this.original);
            Ingredient.m_43940_((FriendlyByteBuf)pb);
            this.nonnulllist.set(0, (Object)Ingredient.m_43940_((FriendlyByteBuf)pb));
            this.nonnulllist.set(1, (Object)Ingredient.m_43940_((FriendlyByteBuf)pb));
            this.result = pb.m_130267_();
            this.recipeId = this.original.m_6423_();
        }

        public boolean m_5818_(Container inv, Level worldIn) {
            return false;
        }

        public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
            return this.result.m_41777_();
        }

        public boolean m_8004_(int width, int height) {
            return false;
        }

        public ItemStack m_8043_(RegistryAccess p_267052_) {
            return this.result;
        }

        public NonNullList<Ingredient> m_7527_() {
            return this.nonnulllist;
        }

        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)Blocks.f_50322_);
        }

        public ResourceLocation m_6423_() {
            return this.recipeId;
        }

        public RecipeSerializer<?> m_7707_() {
            return null;
        }

        public RecipeType<?> m_6671_() {
            return dummy_anvilType;
        }
    }

    static class DummySmithingRecipe
    extends DummyAnvilRecipe {
        public DummySmithingRecipe(SmithingTransformRecipe recipe) {
            super(recipe);
        }

        @Override
        public ItemStack m_8042_() {
            return this.original.m_8042_();
        }

        @Override
        public RecipeType<?> m_6671_() {
            return this.original.m_6671_();
        }
    }

    public static class RecipeView {
        final RecipeType<?> recipeType;
        final ResourceLocation background;
        List<Vec3i> slots = Lists.newArrayList();
        final boolean isWideOutputSlot;

        public RecipeView(RecipeType<?> recipeType, ResourceLocation background, List<Vec3i> slots) {
            this(recipeType, background, slots, true);
        }

        public RecipeView(RecipeType<?> recipeType, ResourceLocation background, List<Vec3i> slots, boolean isWideOutputSlot) {
            this.recipeType = recipeType;
            this.background = background;
            this.slots = slots;
            this.isWideOutputSlot = isWideOutputSlot;
        }
    }

    public static class AdvancementsExGuiEventListener
    implements GuiEventListener {
        AdvancementsScreen screen;
        boolean focus = false;

        public AdvancementsExGuiEventListener(AdvancementsScreen screen) {
            this.screen = screen;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 1) {
                AdvancementsRecipeRenderer.clearGhostRecipe();
                return false;
            }
            int offsetX = (this.screen.f_96543_ - 252) / 2;
            int offsetY = (this.screen.f_96544_ - 140) / 2;
            ItemStack found = null;
            AdvancementTab selectedTab = this.screen.f_97336_;
            if (selectedTab == null) {
                return false;
            }
            int mouseXX = (int)(mouseX - (double)offsetX - 9.0);
            int mouseYY = (int)(mouseY - (double)offsetY - 18.0);
            double scrollX = selectedTab.f_97136_;
            double scrollY = selectedTab.f_97137_;
            Map guis = selectedTab.f_97135_;
            int i = Mth.m_14107_((double)scrollX);
            int j = Mth.m_14107_((double)scrollY);
            if (mouseXX > 0 && mouseXX < 234 && mouseYY > 0 && mouseYY < 113) {
                for (AdvancementWidget advancemententrygui : guis.values()) {
                    if (!advancemententrygui.m_97259_(i, j, mouseXX, mouseYY)) continue;
                    DisplayInfo info = advancemententrygui.f_97243_;
                    found = info.m_14990_();
                    break;
                }
            }
            AdvancementsRecipeRenderer.setGhostRecipe(found);
            return false;
        }

        public void m_93692_(boolean p_265728_) {
            this.focus = p_265728_;
        }

        public boolean m_93696_() {
            return this.focus;
        }
    }
}

